%PSSEFile='test.raw';
% 
%PSSEFile = 'NZ_2007_RootCase1.raw';  

Island = 'NZ';

%
PSSEIn = fopen(PSSEFile,'rt');	%Here we go for the file to read...
if PSSEIn  < 0                  %Perhaps not with success.
 disp(['Try some other value for PSSEFile! I Can''t grab file ',PSSEFile]);	%Oh well.
 return;                        %Give up.
end;                            %So much for a token check.
%
% Deal to header lines
aline=fgetl(PSSEIn);
[PSSE.IC,PSSE.SBASE] = strread([aline(1:21),','],'%f%f','delimiter',',');	%Comma-separated reals.
PSSE.Date=aline(23:size(aline,2));
PSSE.Title1=fgetl(PSSEIn);
PSSE.Title2=fgetl(PSSEIn);
%
% read the bus data
%
aline=fgetl(PSSEIn);
nb=0;
while aline(1:1 ) ~= '0'
    nb=nb+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).BUS.I(nb),PSSE.(Island).BUS.NAME(nb),PSSE.(Island).BUS.BASKV(nb),PSSE.(Island).BUS.IDE(nb),...
       PSSE.(Island).BUS.AREA(nb),PSSE.(Island).BUS.ZONE(nb),...
       PSSE.(Island).BUS.VM(nb),PSSE.(Island).BUS.VA(nb),PSSE.(Island).BUS.OWNER(nb)]=...
       strread(aline,'%f%q%f%f%f%f%f%f%f','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NBUS=nb;
clear nb
%
% read load data
%
aline=fgetl(PSSEIn);
nl=0;
while aline(1:1 ) ~= '0'
    nl=nl+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).LOAD.I(nl),PSSE.(Island).LOAD.ID(nl),PSSE.(Island).LOAD.STATUS(nl),PSSE.(Island).LOAD.AREA(nl),PSSE.(Island).LOAD.ZONE(nl),...
        PSSE.(Island).LOAD.PL(nl),PSSE.(Island).LOAD.QL(nl),PSSE.(Island).LOAD.IP(nl),PSSE.(Island).LOAD.IQ(nl),PSSE.(Island).LOAD.YP(nl),...
        PSSE.(Island).LOAD.YQ(nl),PSSE.(Island).LOAD.OWNER(nl)]=...
        strread(aline,'%f%q%f%f%f%f%f%f%f%f%f%f','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NLOAD=nl;
clear nl
%
% read fixed shunt data
%
aline=fgetl(PSSEIn);
nl=0;
while aline(1:1 ) ~= '0'
    nl=nl+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).SHUNT.I(nl),PSSE.(Island).SHUNT.First(nl),PSSE.(Island).SHUNT.SECOND(nl),PSSE.(Island).SHUNT.THIRD(nl),PSSE.(Island).SHUNT.FOURTH(nl)]=...
        strread(aline,'%f%q%f%f%f','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NSHUNT=nl;
clear nl
%
% read generator data
%
aline=fgetl(PSSEIn);
ng=0;
while aline(1:1 ) ~= '0'
    ng=ng+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).GEN.I(ng),PSSE.(Island).GEN.ID(ng),PSSE.(Island).GEN.PG(ng),PSSE.(Island).GEN.QG(ng),PSSE.(Island).GEN.QT(ng),...
        PSSE.(Island).GEN.QB(ng),PSSE.(Island).GEN.VS(ng),PSSE.(Island).GEN.IREG(ng),PSSE.(Island).GEN.MBASE(ng),PSSE.(Island).GEN.ZR(ng),...
        PSSE.(Island).GEN.ZX(ng),PSSE.(Island).GEN.RT(ng),PSSE.(Island).GEN.XT(ng),PSSE.(Island).GEN.GTAP(ng),PSSE.(Island).GEN.STAT(ng),...
        PSSE.(Island).GEN.RMPCT(ng),PSSE.(Island).GEN.PT(ng),PSSE.(Island).GEN.PB(ng),PSSE.(Island).GEN.O1(ng),PSSE.(Island).GEN.F1(ng)]=...
        strread(aline,'%f%q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NGEN=ng;
clear ng
%
% read branch data
%
aline=fgetl(PSSEIn);
nb=0;
while aline(1:1 ) ~= '0'
    nb=nb+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).BRANCH.I(nb),PSSE.(Island).BRANCH.J(nb),PSSE.(Island).BRANCH.CKT(nb),PSSE.(Island).BRANCH.R(nb),PSSE.(Island).BRANCH.X(nb),...
        PSSE.(Island).BRANCH.B(nb),PSSE.(Island).BRANCH.RATEA(nb),PSSE.(Island).BRANCH.RATEB(nb),PSSE.(Island).BRANCH.RATEC(nb),PSSE.(Island).BRANCH.GI(nb),...
        PSSE.(Island).BRANCH.BI(nb),PSSE.(Island).BRANCH.GJ(nb),PSSE.(Island).BRANCH.BJ(nb),PSSE.(Island).BRANCH.ST(nb),PSSE.(Island).BRANCH.ST2(nb),PSSE.(Island).BRANCH.LEN(nb),...
        PSSE.(Island).BRANCH.O1(nb),PSSE.(Island).BRANCH.F1(nb)]=...
        strread(aline,'%f%f%q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NBRANCH=nb;
clear nb
%
%
% read transformer data
%
aline=fgetl(PSSEIn);
nt=0;
clear XX
while aline(1:1 ) ~= '0'
    nt=nt+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).XFMR.I(nt),PSSE.(Island).XFMR.J(nt),PSSE.(Island).XFMR.K(nt),PSSE.(Island).XFMR.CKT(nt),PSSE.(Island).XFMR.CW(nt),...
        PSSE.(Island).XFMR.CZ(nt),PSSE.(Island).XFMR.CM(nt),PSSE.(Island).XFMR.MAG1(nt),PSSE.(Island).XFMR.MAG2(nt),PSSE.(Island).XFMR.NMETR(nt),...
        PSSE.(Island).XFMR.NAME(nt),PSSE.(Island).XFMR.STAT(nt),PSSE.(Island).XFMR.O1(nt),PSSE.(Island).XFMR.F1(nt)]=...
        strread(aline,'%f%f%f%q%f%f%f%f%f%f%q%f%f%f','delimiter',',');
    if PSSE.(Island).XFMR.K(nt) ~= 0     %three winding transformer
        aline=fgetl(PSSEIn);
        aline=fgetl(PSSEIn);
        aline=fgetl(PSSEIn);
        aline=fgetl(PSSEIn);
        disp('three winding transformer NOT HANDLED - Matlab read code will need to be modified')
    else                        %two winding transformer
        aline=fgetl(PSSEIn);
        [PSSE.(Island).XFMR.R1_2(nt),PSSE.(Island).XFMR.X1_2(nt),PSSE.(Island).XFMR.SBASE1_2(nt)]=...
            strread(aline,'%f%f%f','delimiter',',');
        aline=fgetl(PSSEIn);
        [PSSE.(Island).XFMR.WINDV1(nt),PSSE.(Island).XFMR.NOMV1(nt),PSSE.(Island).XFMR.ANG1(nt),PSSE.(Island).XFMR.RATA1(nt),PSSE.(Island).XFMR.RATB1(nt),...
            PSSE.(Island).XFMR.RATC1(nt),PSSE.(Island).XFMR.COD(nt),PSSE.(Island).XFMR.CONT(nt),PSSE.(Island).XFMR.RMA(nt),PSSE.(Island).XFMR.RMI(nt),...
            PSSE.(Island).XFMR.VMA(nt),PSSE.(Island).XFMR.VMI(nt),PSSE.(Island).XFMR.NTP(nt),PSSE.(Island).XFMR.TAB(nt),PSSE.(Island).XFMR.CR(nt),PSSE.(Island).XFMR.CX(nt)]=...
            strread(aline,'%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f','delimiter',',');
        aline=fgetl(PSSEIn);
        [PSSE.(Island).XFMR.WINDV2(nt),PSSE.(Island).XFMR.NOMV2(nt)]=...
            strread(aline,'%f%f','delimiter',',');   
    end
    %
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NXFMR=nt;
clear nt
%
% read area data
%
aline=fgetl(PSSEIn);
na=0;
while aline(1:1 ) ~= '0'
    na=na+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).AREA.I(na),PSSE.(Island).AREA.ISW(na),PSSE.(Island).AREA.PDES(na),PSSE.(Island).AREA.PTOL(na),PSSE.(Island).AREA.ARNAME(na)]=...
        strread(aline,'%f%f%f%f%q','delimiter',',');
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NAREA=na;
clear na
%
% read two terminal dc data
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
% read VSC dc line data
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
% read IMPEDANCE CORRECTION DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read BEGIN MULTI-TERMINAL DC DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read MULTI-SECTION LINE DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read ZONE DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read INTER-AREA TRANSFER DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read OWNER DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
%read FACTS DEVICE DATA
%
aline=fgetl(PSSEIn);
while aline(1:1 ) ~= '0'
    aline=fgetl(PSSEIn);
end
%
% read switched shunt data
%
aline=fgetl(PSSEIn);
ns=0;
while aline(1:1 ) ~= '0'
    ns=ns+1;
    aline=strrep(aline,'''','"');
    [PSSE.(Island).SHUNT.I(ns),PSSE.(Island).SHUNT.MODSW(ns),PSSE.(Island).SHUNT.VSWHI(ns),PSSE.(Island).SHUNT.VSWLO(ns),PSSE.(Island).SHUNT.SWREM(ns),...
    PSSE.(Island).SHUNT.ContVar(ns),PSSE.(Island).SHUNT.RMIDNT(ns),PSSE.(Island).SHUNT.BINIT(ns),PSSE.(Island).SHUNT.N1(ns),PSSE.(Island).SHUNT.B1(ns),... % added ContVar for this version of PSSE raw file (BK)
    N2,B2,N3,B3,N4,B4,N5,B5,N6,B6,N7,B7,N8,B8]=...
        strread(aline,'%f%f%f%f%f%f%q%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f','delimiter',',');
    if isempty(N2); PSSE.(Island).SHUNT.N2(ns)=0; PSSE.(Island).SHUNT.B2(ns)=0; else PSSE.(Island).SHUNT.N2(ns)=N2; PSSE.(Island).SHUNT.B2(ns)=B2;  end;
    if isempty(N3); PSSE.(Island).SHUNT.N3(ns)=0; PSSE.(Island).SHUNT.B3(ns)=0; else PSSE.(Island).SHUNT.N3(ns)=N3; PSSE.(Island).SHUNT.B3(ns)=B3;  end;
    if isempty(N4); PSSE.(Island).SHUNT.N4(ns)=0; PSSE.(Island).SHUNT.B4(ns)=0; else PSSE.(Island).SHUNT.N4(ns)=N4; PSSE.(Island).SHUNT.B4(ns)=B4;  end;
    if isempty(N5); PSSE.(Island).SHUNT.N5(ns)=0; PSSE.(Island).SHUNT.B5(ns)=0; else PSSE.(Island).SHUNT.N5(ns)=N5; PSSE.(Island).SHUNT.B5(ns)=B5;  end;
    if isempty(N6); PSSE.(Island).SHUNT.N6(ns)=0; PSSE.(Island).SHUNT.B6(ns)=0; else PSSE.(Island).SHUNT.N6(ns)=N6; PSSE.(Island).SHUNT.B6(ns)=B6;  end;
    if isempty(N7); PSSE.(Island).SHUNT.N7(ns)=0; PSSE.(Island).SHUNT.B7(ns)=0; else PSSE.(Island).SHUNT.N7(ns)=N7; PSSE.(Island).SHUNT.B7(ns)=B7;  end;
    if isempty(N8); PSSE.(Island).SHUNT.N8(ns)=0; PSSE.(Island).SHUNT.B8(ns)=0; else PSSE.(Island).SHUNT.N8(ns)=N8; PSSE.(Island).SHUNT.B8(ns)=B8;  end;        
    aline=fgetl(PSSEIn);
end
PSSE.(Island).NSHUNT=ns;
clear ns
%
fclose(PSSEIn); clear PSSEIn;	%Presume success.

display(['Processed', PSSEFile]);

